/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource.transformer;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.md_5.specialsource.transformer.MappingTransformer;
import net.md_5.specialsource.transformer.MethodDescriptor;

public class MavenShade
extends MappingTransformer {
    public LinkedHashMap<String, String> relocations = new LinkedHashMap();
    public static final MavenShade IDENTITY = new MavenShade();

    private MavenShade() {
    }

    public MavenShade(Map<String, String> relocations) {
        for (Map.Entry<String, String> entry : relocations.entrySet()) {
            this.relocations.put(MavenShade.toInternalName(entry.getKey()), MavenShade.toInternalName(entry.getValue()));
        }
    }

    public MavenShade(List<String> list) {
        for (String pair : list) {
            int index = pair.indexOf("=");
            if (index == -1) {
                throw new IllegalArgumentException("ShadeRelocationSimulator invalid relocation string, missing =: " + pair);
            }
            String pattern = pair.substring(0, index);
            String shadedPattern = pair.substring(index + 1);
            this.relocations.put(MavenShade.toInternalName(pattern), MavenShade.toInternalName(shadedPattern));
        }
    }

    public MavenShade(String string) {
        this(Arrays.asList(string.split(",")));
    }

    @Override
    public String transformClassName(String className) {
        for (Map.Entry<String, String> entry : this.relocations.entrySet()) {
            String pattern = entry.getKey();
            String shadedPattern = entry.getValue();
            if (!className.startsWith(MavenShade.toInternalName(pattern))) continue;
            String newClassName = MavenShade.toInternalName(shadedPattern) + className.substring(pattern.length());
            return newClassName;
        }
        return className;
    }

    @Override
    public String transformMethodDescriptor(String oldDescriptor) {
        MethodDescriptor methodDescriptorTransformer = new MethodDescriptor(this.relocations, null);
        return methodDescriptorTransformer.transform(oldDescriptor);
    }

    public static String toInternalName(String className) {
        return className.replace('.', '/');
    }
}

